import pandas as pd
import os
from molactivity.E1_structure_analysis import SMILESAnalyzer

def main():
    input_file = 'train_sample.csv'
    smiles_col = 'SMILES'
    output_dir = 'analysis_results'
    
    df = pd.read_csv(input_file)
    activity_col = None
    if 'ACTIVITY' in df.columns:
        activity_col = 'ACTIVITY'
    
    print(f"data to be analyzed: {input_file}")
    print(f"smiles_col: {smiles_col}")
    if activity_col:
        print(f"activity_col: {activity_col}")
    
    analyzer = SMILESAnalyzer(
        file_path=input_file, 
        smiles_column=smiles_col,
        activity_column=activity_col
    )
    
    output_dir = analyzer.generate_visualizations(output_dir=output_dir)
    
    analyzer.save_analysis_report(os.path.join(output_dir, "smiles_analysis_report.csv"))
    
    if activity_col:
        print("comparing active and inactive smiles...")
        comparison_df = analyzer.compare_active_inactive(activity_threshold=0.5)
        if comparison_df is not None:
            comparison_df.to_csv(os.path.join(output_dir, 'active_inactive_comparison.csv'))
    
    print(f"results saved to folder {output_dir}")


if __name__ == "__main__":
    main() 